/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CTimerImp.h,v 1.2 1999/09/17 04:20:45 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CTimerImp_h	// [
#define Included_CTimerImp_h

#include "pgpClassesConfig.h"

#include "CImp.h"
#include "CTimer.h"

_PGP_BEGIN

// Class CTimerImp

class CTimerImp : public CImp
{
	friend class CTimer;

protected:
	CTimerImp() : mTimerCallback(NULL), mUserData(NULL), 
		mIsTimerRunning(FALSE) { }

	virtual PGPBoolean	IsPeriodic() const {return mIsPeriodic;}
	virtual PGPBoolean	IsTimerRunning() const {return mIsTimerRunning;}

	virtual SMART_ERROR	StartTimer(CTimer::CallbackFunc timerCallback, 
		void *userData, PGPUInt32 msInterval, PGPBoolean isPeriodic) = 0;
	virtual void		StopTimer() = 0;

protected:
	PGPBoolean	mIsTimerRunning;

	CTimer::CallbackFunc	mTimerCallback;
	void		*mUserData;
	PGPUInt32	mMsInterval;
	PGPBoolean	mIsPeriodic;
};

_PGP_END

#endif	// ] Included_CTimerImp_h
